/*******************************************************************************

   Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

 *******************************************************************************

   $Id:: SercosIII_SlCOM_Public.h 73703 2018-01-23 12:44:11Z DenisJ            $

   Description:
    SERCOSIII Slave COM Task

    Includes following functions:

   Changes:

     Date          Description
     ---------------------------------------------------------------------------
     2009-08-15    Created
*******************************************************************************/
/**
 * @file SercosIII_SlCOM_Public.h
 *  SercosIII_Sl COM - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 *
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 * The <code>#pragma</code> instructions are already planned for Microsoft compiler.
 * For gnu's compiler and Realview compiler the macros <code>__TLR_PACKED_PRE</code>
 * and <code>__TLR_PACKED_POST</code> have to be added with the structural definition
 * in addition.
 */
#ifndef __SIII_SL_COM_PUBLIC_H
#define __SIII_SL_COM_PUBLIC_H


/*************************************************************************************/
#ifndef SIII_SL_COM_MAX_NUM_SLAVES_IN_DEVICE
#define SIII_SL_COM_MAX_NUM_SLAVES_IN_DEVICE            8
#endif

#ifndef SIII_SL_COM_MAX_NUM_TRACE_BUFFER_REGISTRATIONS_PER_SLAVE
#define SIII_SL_COM_MAX_NUM_TRACE_BUFFER_REGISTRATIONS_PER_SLAVE        4
#endif

/*number of entries in all diag traces must be the same (also in the advanced diag traces S-0-1303.0.12 - S-0-1303.0.127)*/
#ifndef SIII_SL_COM_NUM_DIAG_TRACE_ENTRIES
  #define SIII_SL_COM_NUM_DIAG_TRACE_ENTRIES      (512)
#endif

#ifndef SIII_SL_COM_NUM_PROCEDURE_COMMAND_SPECIFIC_STATE_TRACE_ENTRIES
  #define SIII_SL_COM_NUM_PROCEDURE_COMMAND_SPECIFIC_STATE_TRACE_ENTRIES (32) /* 32 / 8 = 4 -> 4 Operational State diagnosis parallel */
#endif

#ifndef SIII_SL_COM_NUM_OPERATIONAL_STATE_TRACE_ENTRIES
  #define SIII_SL_COM_NUM_OPERATIONAL_STATE_TRACE_ENTRIES (32) /* 32 / 8 = 4 -> 4 Procedure Command diagnosis parallel */
#endif

#ifndef SIII_SL_COM_NUM_DIAG_MESSAGE_ENTRIES
  #define SIII_SL_COM_NUM_DIAG_MESSAGE_ENTRIES    (64)
#endif

/** queue name */
#define SIII_SL_COM_QUEUE_NAME        "QUE_S3_SL_COM"

#define MSK_SIII_SL_COM_DIAGNOSTIC_TRACE_CONTROL_BUFFER_MODE  0x8000
#define VAL_SIII_SL_COM_DIAGNOSTIC_TRACE_CONTROL_LIST_BUFFER  0x8000
#define VAL_SIII_SL_COM_DIAGNOSTIC_TRACE_CONTROL_RING_BUFFER  0x0000
#define VAL_SIII_SL_COM_DIAGNOSTIC_TRACE_CONTROL_RESET        0x0002

#define VAL_SIII_SL_COM_DIAGNOSTIC_TRACE_THRESHOLT            0x00F0
#define VAL_SIII_SL_COM_DIAGNOSTIC_TRACE_FREEZE_BUFFER        0x0001
#define VAL_SIII_SL_COM_DIAGNOSTIC_TRACE_STATE_OVERRUN        0x0008
#define MSK_SIII_SL_COM_DIAGNOSTIC_LEVEL_INDICATOR            0x0006
#define VAL_SIII_SL_COM_DIAGNOSTIC_LEVEL_INDICATOR_NA         0x0000
#define VAL_SIII_SL_COM_DIAGNOSTIC_LEVEL_INDICATOR_EMPTY      0x0002
#define VAL_SIII_SL_COM_DIAGNOSTIC_LEVEL_INDICATOR_FILLED     0x0004
#define VAL_SIII_SL_COM_DIAGNOSTIC_LEVEL_INDICATOR_FULL       0x0006

#define VAL_SIII_SL_COM_ACTIVE_DIAGNOSIS_TRACE_STARTED        0x0001
#define VAL_SIII_SL_COM_ACTIVE_DIAGNOSIS_TRACE_STOPPED        0x0002


/* packet commands */
#define SIII_SL_COM_CMD_PHASE_CHANGE_IND                                     0x00003206 /* phase change signalling is enabled via RCX_REGISTER_APP_REQ */
#define SIII_SL_COM_CMD_PHASE_CHANGE_RES                                     0x00003207

#define SIII_SL_COM_CMD_HOST_WDG_FAILED_REQ                                  0x0000320A
#define SIII_SL_COM_CMD_HOST_WDG_FAILED_CNF                                  0x0000320B

#define SIII_SL_COM_CMD_REGISTER_CPX_CHECK_REQ                               0x00003240
#define SIII_SL_COM_CMD_REGISTER_CPX_CHECK_CNF                               0x00003241

#define SIII_SL_COM_CMD_UNREGISTER_CPX_CHECK_REQ                             0x00003242
#define SIII_SL_COM_CMD_UNREGISTER_CPX_CHECK_CNF                             0x00003243


/* indications activated by SIII_SL_COM_CMD_REGISTER_CPX_CHECK_REQ */
#define SIII_SL_COM_CMD_PROC_CMD_S_0_0127_EXEC_IND                           0x00003250
#define SIII_SL_COM_CMD_PROC_CMD_S_0_0127_EXEC_RES                           0x00003251

#define SIII_SL_COM_CMD_PROC_CMD_S_0_0128_EXEC_IND                           0x00003252
#define SIII_SL_COM_CMD_PROC_CMD_S_0_0128_EXEC_RES                           0x00003253

#define SIII_SL_COM_CMD_PROC_CMD_S_0_1024_EXEC_IND                           0x00003254
#define SIII_SL_COM_CMD_PROC_CMD_S_0_1024_EXEC_RES                           0x00003255

/* indications activated by RCX_REGISTER_APP_REQ */
#define SIII_SL_COM_CMD_SET_IDENT_LED_IND                                    0x00003260
#define SIII_SL_COM_CMD_SET_IDENT_LED_RES                                    0x00003261

#define SIII_SL_COM_CMD_UPDATE_DEVICE_STATUS_REQ                             0x00003264
#define SIII_SL_COM_CMD_UPDATE_DEVICE_STATUS_CNF                             0x00003265

#define SIII_SL_COM_CMD_SET_SERCOS_ADDRESSES_REQ                             0x00003266
#define SIII_SL_COM_CMD_SET_SERCOS_ADDRESSES_CNF                             0x00003267

#define SIII_SL_COM_CMD_SERCOS_ADDRESS_CHANGED_IND                           0x00003268
#define SIII_SL_COM_CMD_SERCOS_ADDRESS_CHANGED_RES                           0x00003269

#define SIII_SL_COM_CMD_SLAVE_COM_STATUS_CHANGED_IND                         0x0000326A
#define SIII_SL_COM_CMD_SLAVE_COM_STATUS_CHANGED_RES                         0x0000326B

/* Initialization completion indication by all parts related to device/slave */
#define SIII_SL_COM_CMD_INIT_COMPLETED_IND                                   0x00003270
#define SIII_SL_COM_CMD_INIT_COMPLETED_RES                                   0x00003271

#define SIII_SL_COM_CMD_WRITE_DIAGNOSTIC_REQ                                 0x00003290
#define SIII_SL_COM_CMD_WRITE_DIAGNOSTIC_CNF                                 0x00003291

/* S-0-0099 reset diagnostic linkage */
#define SIII_SL_COM_CMD_REGISTER_S_0_99_INDICATIONS_REQ                      0x000032A0
#define SIII_SL_COM_CMD_REGISTER_S_0_99_INDICATIONS_CNF                      0x000032A1

#define SIII_SL_COM_CMD_UNREGISTER_S_0_99_INDICATIONS_REQ                    0x000032A2
#define SIII_SL_COM_CMD_UNREGISTER_S_0_99_INDICATIONS_CNF                    0x000032A3

#define SIII_SL_COM_CMD_PROC_CMD_S_0_0099_EXEC_IND                           0x000032A4
#define SIII_SL_COM_CMD_PROC_CMD_S_0_0099_EXEC_RES                           0x000032A5

/* Trace Buffer Indications */
#define SIII_SL_COM_CMD_REGISTER_TRACE_BUFFER_INDICATIONS_REQ                0x000032A6
#define SIII_SL_COM_CMD_REGISTER_TRACE_BUFFER_INDICATIONS_CNF                0x000032A7

#define SIII_SL_COM_CMD_UNREGISTER_TRACE_BUFFER_INDICATIONS_REQ              0x000032A8
#define SIII_SL_COM_CMD_UNREGISTER_TRACE_BUFFER_INDICATIONS_CNF              0x000032A9

#define SIII_SL_COM_CMD_TRACE_BUFFER_UPDATE_IND                              0x000032AA
#define SIII_SL_COM_CMD_TRACE_BUFFER_UPDATE_RES                              0x000032AB

/* Remove diagnosis packet */
#define SIII_SL_COM_CMD_REMOVE_DIAGNOSTIC_REQ                                0x000032AC
#define SIII_SL_COM_CMD_REMOVE_DIAGNOSTIC_CNF                                0x000032AD


/* Test Pin Diagnosis Event */
#define SIII_SL_COM_CMD_REGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_REQ   0x000032AE
#define SIII_SL_COM_CMD_REGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_CNF   0x000032AF

#define SIII_SL_COM_CMD_UNREGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_REQ 0x000032B0
#define SIII_SL_COM_CMD_UNREGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_CNF 0x000032B1

#define SIII_SL_COM_CMD_TEST_IDN_DIAGNOSTIC_EVENT_IND                        0x000032B2
#define SIII_SL_COM_CMD_TEST_IDN_DIAGNOSTIC_EVENT_RES                        0x000032B3

#define SIII_SL_COM_CMD_LIMITATION_LIB_EXPIRED_IND                           0x000032B4 /* internal packet just for limited libraries, tell AP task time limit reached */
#define SIII_SL_COM_CMD_LIMITATION_LIB_EXPIRED_RES                           0x000032B5

/* Change DivClk Settings in CP3/CP4 */
#define SIII_SL_COM_CMD_CHANGE_DIVCLK_SETTINGS_IN_CP3_CP4_REQ                0x000032B6
#define SIII_SL_COM_CMD_CHANGE_DIVCLK_SETTINGS_IN_CP3_CP4_CNF                0x000032B7

/* Change Connection Data Offsets */
#define SIII_SL_COM_CMD_CHANGE_CONNECTION_DATA_OFFSETS_REQ                   0x000032B8
#define SIII_SL_COM_CMD_CHANGE_CONNECTION_DATA_OFFSETS_CNF                   0x000032B9

/* Command for SIP task */
#define SIII_SL_COM_CMD_IDENT_REQ                                            0x000032DC
#define SIII_SL_COM_CMD_IDENT_RES                                            0x000032DD


/* Command for AP task */
#define SIII_SL_COM_CMD_DPM_WATCHDOG_TIMEOUT_IND                             0x000032DE
#define SIII_SL_COM_CMD_DPM_WATCHDOG_TIMEOUT_RES                             0x000032DF



/* 0x32B0-0x32B1 reserved */
/* 0x32DE-0x32FF reserved */


/*************************************************************************************/
/* packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__SIII_SL_COM_PACKET)
#endif


/** @name Packet Definition
 *
 * The following defined structures represent the packets of the several services,
 * which are supported by the task.
 * @{
 */


/******************************************************************************
 * Packet:  SIII_SL_COM_CMD_PHASE_CHANGE_IND/SIII_SL_COM_CMD_PHASE_CHANGE_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_PHASE_CHANGE_IND_DATA_Ttag
{
  TLR_UINT8         bCurrentComPhase;
} __TLR_PACKED_POST SIII_SL_COM_PHASE_CHANGE_IND_DATA_T;

#define VAL_SIII_SL_COM_PHASE_CHANGE_IND_CP0         0x00
#define VAL_SIII_SL_COM_PHASE_CHANGE_IND_CP1S        0x81
#define VAL_SIII_SL_COM_PHASE_CHANGE_IND_CP1         0x01
#define VAL_SIII_SL_COM_PHASE_CHANGE_IND_CP2         0x02
#define VAL_SIII_SL_COM_PHASE_CHANGE_IND_CP3         0x03
#define VAL_SIII_SL_COM_PHASE_CHANGE_IND_CP4         0x04
#define VAL_SIII_SL_COM_PHASE_CHANGE_IND_NRT         0x7F
#define VAL_SIII_SL_COM_PHASE_CHANGE_IND_HP0         0x30
#define VAL_SIII_SL_COM_PHASE_CHANGE_IND_HP1         0x31
#define VAL_SIII_SL_COM_PHASE_CHANGE_IND_HP2         0x32
#define VAL_SIII_SL_COM_PHASE_CHANGE_IND_HP2_S_0_127 0x33

typedef struct SIII_SL_COM_PHASE_CHANGE_IND_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                               tHead;
  /** packet data */
  SIII_SL_COM_PHASE_CHANGE_IND_DATA_T               tData;
} SIII_SL_COM_PHASE_CHANGE_IND_T;


/* response packet */
typedef struct SIII_SL_COM_PHASE_CHANGE_RES_Ttag
{
  /** packet header */
  TLR_PACKET_HEADER_T                               tHead;
} SIII_SL_COM_PHASE_CHANGE_RES_T;


/******************************************************************************
 * Packet: SIII_SL_COM_CMD_SLAVE_COM_STATUS_CHANGED_IND/SIII_SL_COM_CMD_SLAVE_COM_STATUS_CHANGED_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_SLAVE_COM_STATUS_CHANGED_IND_DATA_Ttag
{
  TLR_UINT32                                        ulC1DDiagnosticsActive;   /* one bit per slave */
  TLR_UINT32                                        ulCommunicationErrorActive;
  TLR_BOOLEAN32                                     fLoopbackStatus;
  TLR_UINT32                                        ulC2DDiagnosticsActive;   /* one bit per slave */
} __TLR_PACKED_POST SIII_SL_COM_SLAVE_COM_STATUS_CHANGED_IND_DATA_T;

typedef struct SIII_SL_COM_SLAVE_COM_STATUS_CHANGED_IND_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_SLAVE_COM_STATUS_CHANGED_IND_DATA_T   tData;
} SIII_SL_COM_SLAVE_COM_STATUS_CHANGED_IND_T;

/* response packet */
typedef struct SIII_SL_COM_SLAVE_COM_STATUS_CHANGED_RES_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} SIII_SL_COM_SLAVE_COM_STATUS_CHANGED_RES_T;

/******************************************************************************
 * Packet: SIII_SL_COM_CMD_REGISTER_CPX_CHECK_REQ/SIII_SL_COM_CMD_REGISTER_CPX_CHECK_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_REGISTER_CPX_CHECK_REQ_DATA_Ttag
{
  TLR_UINT8                                         bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_REGISTER_CPX_CHECK_REQ_DATA_T;

typedef struct SIII_SL_COM_REGISTER_CPX_CHECK_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_REGISTER_CPX_CHECK_REQ_DATA_T         tData;
} SIII_SL_COM_REGISTER_CPX_CHECK_REQ_T;


/* response packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_REGISTER_CPX_CHECK_CNF_DATA_Ttag
{
  TLR_UINT8                                         bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_REGISTER_CPX_CHECK_CNF_DATA_T;

typedef struct SIII_SL_COM_REGISTER_CPX_CHECK_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_REGISTER_CPX_CHECK_CNF_DATA_T         tData;
} SIII_SL_COM_REGISTER_CPX_CHECK_CNF_T;


/******************************************************************************
 * Packet: SIII_SL_COM_CMD_UNREGISTER_CPX_CHECK_REQ/SIII_SL_COM_CMD_UNREGISTER_CPX_CHECK_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_UNREGISTER_CPX_CHECK_REQ_DATA_Ttag
{
  TLR_UINT8                                         bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_UNREGISTER_CPX_CHECK_REQ_DATA_T;

typedef struct SIII_SL_COM_UNREGISTER_CPX_CHECK_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_UNREGISTER_CPX_CHECK_REQ_DATA_T       tData;
} SIII_SL_COM_UNREGISTER_CPX_CHECK_REQ_T;


/* response packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_UNREGISTER_CPX_CHECK_CNF_DATA_Ttag
{
  TLR_UINT8                                         bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_UNREGISTER_CPX_CHECK_CNF_DATA_T;

typedef struct SIII_SL_COM_UNREGISTER_CPX_CHECK_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_UNREGISTER_CPX_CHECK_CNF_DATA_T       tData;
} SIII_SL_COM_UNREGISTER_CPX_CHECK_CNF_T;


/******************************************************************************
 * Packet: SIII_SL_COM_CMD_PROC_CMD_S_0_0127_EXEC_IND/SIII_SL_COM_CMD_PROC_CMD_S_0_0127_EXEC_RES
 */
/* indication packet */
#define SIII_SL_COM_PROC_CMD_S_0_0127_NUM_CONNECTIONS       4

typedef __TLR_PACKED_PRE struct SIII_SL_COM_PROC_CMD_S_0_0127_CONN_INFO_IND_Ttag
{
  TLR_UINT16                                        usConnectionSetup;
  TLR_UINT16                                        usProcImgConnCtrlOffset;
  TLR_UINT16                                        usProcImgRtDataOffset;
  TLR_UINT16                                        usProcImgMaxRtDataLength;
} __TLR_PACKED_POST SIII_SL_COM_PROC_CMD_S_0_0127_CONN_INFO_IND_T;

typedef __TLR_PACKED_PRE struct SIII_SL_COM_PROC_CMD_S_0_0127_EXEC_IND_DATA_Ttag
{
  TLR_UINT8                                         bSlaveIdx;
  TLR_UINT32                                        ulCommunicationCycle;       /* in ns */
  TLR_UINT32                                        ulAtTransmissionStartTime;  /* in ns, only valid if SCP_Sync is enabled */
  SIII_SL_COM_PROC_CMD_S_0_0127_CONN_INFO_IND_T     atConnInfo[SIII_SL_COM_PROC_CMD_S_0_0127_NUM_CONNECTIONS];
} __TLR_PACKED_POST SIII_SL_COM_PROC_CMD_S_0_0127_EXEC_IND_DATA_T;

typedef struct SIII_SL_COM_PROC_CMD_S_0_0127_EXEC_IND_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_PROC_CMD_S_0_0127_EXEC_IND_DATA_T     tData;
} SIII_SL_COM_PROC_CMD_S_0_0127_EXEC_IND_T;


/* response packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_PROC_CMD_S_0_0127_CONN_INFO_RES_Ttag
{
  TLR_UINT16                                        usProcImgConnCtrlOffset;
  TLR_UINT16                                        usProcImgRtDataOffset;
  TLR_UINT16                                        usProcImgMaxRtDataLength;
} __TLR_PACKED_POST SIII_SL_COM_PROC_CMD_S_0_0127_CONN_INFO_RES_T;

#define SIII_SL_COM_PROC_CMD_S_0_0127_EXEC_RES_DATA_MAX_IDNS_PER_SEGMENT    (1024 / sizeof(TLR_UINT32))
#define SIII_SL_COM_PROC_CMD_S_0_0127_EXEC_RES_MIN_SIZE                     (sizeof(SIII_SL_COM_PROC_CMD_S_0_0127_EXEC_RES_DATA_T) - sizeof(TLR_UINT32) * SIII_SL_COM_PROC_CMD_S_0_0127_EXEC_RES_DATA_MAX_IDNS_PER_SEGMENT)

typedef __TLR_PACKED_PRE struct SIII_SL_COM_PROC_CMD_S_0_0127_EXEC_RES_DATA_Ttag
{
  TLR_UINT8                                         bSlaveIdx;
  TLR_BOOLEAN32                                     fModifyConnInfo;
  TLR_BOOLEAN32                                     fModifySyncConfiguration;

  /* { sync configuration
   * last received configuration is valid as it is shared between all slaves in a device.
   */
  TLR_UINT32                                        ulDivModeControl;
  TLR_UINT32                                        ulConClkLength;
  TLR_UINT32                                        ulTDivClk;
  TLR_UINT32                                        ulDTDivClk;     /* since V3.1.X: not used any more */
  TLR_UINT32                                        ulDivClkLength; /* since V3.1.X: not used any more (default 1us) */
  TLR_UINT32                                        ulNDivClk;
  TLR_UINT32                                        ulTInt2; /* not used */
  TLR_UINT32                                        ulTInt3; /* not used */
  /* } sync configuration */

  /* { connection info
   * configuration per slave
   */
  SIII_SL_COM_PROC_CMD_S_0_0127_CONN_INFO_RES_T     atConnInfo[SIII_SL_COM_PROC_CMD_S_0_0127_NUM_CONNECTIONS];
  /* } connection info */

  TLR_UINT32                                        aulS_0_0021_List[SIII_SL_COM_PROC_CMD_S_0_0127_EXEC_RES_DATA_MAX_IDNS_PER_SEGMENT];
} __TLR_PACKED_POST SIII_SL_COM_PROC_CMD_S_0_0127_EXEC_RES_DATA_T;

#define SIII_SL_COM_PROC_CMD_S_0_0127_DIV_MODE_CONTROL_DISABLED               0
#define SIII_SL_COM_PROC_CMD_S_0_0127_DIV_MODE_CONTROL_SET_MODE_0             1
#define SIII_SL_COM_PROC_CMD_S_0_0127_DIV_MODE_CONTROL_SET_MODE_1             2

typedef struct SIII_SL_COM_PROC_CMD_S_0_0127_EXEC_RES_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_PROC_CMD_S_0_0127_EXEC_RES_DATA_T     tData;
} SIII_SL_COM_PROC_CMD_S_0_0127_EXEC_RES_T;


/******************************************************************************
 * Packet: SIII_SL_COM_CMD_PROC_CMD_S_0_0128_EXEC_IND/SIII_SL_COM_CMD_PROC_CMD_S_0_0128_EXEC_RES
 */
/* indication packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_PROC_CMD_S_0_0128_EXEC_IND_DATA_Ttag
{
  TLR_UINT8                                         bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_PROC_CMD_S_0_0128_EXEC_IND_DATA_T;

typedef struct SIII_SL_COM_PROC_CMD_S_0_0128_EXEC_IND_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_PROC_CMD_S_0_0128_EXEC_IND_DATA_T     tData;
} SIII_SL_COM_PROC_CMD_S_0_0128_EXEC_IND_T;


/* response packet */
#define SIII_SL_COM_PROC_CMD_S_0_0128_EXEC_RES_DATA_MAX_IDNS_PER_SEGMENT    (1024 / sizeof(TLR_UINT32))
#define SIII_SL_COM_PROC_CMD_S_0_0128_EXEC_RES_MIN_SIZE                     (sizeof(SIII_SL_COM_PROC_CMD_S_0_0128_EXEC_RES_DATA_T) - sizeof(TLR_UINT32) * SIII_SL_COM_PROC_CMD_S_0_0128_EXEC_RES_DATA_MAX_IDNS_PER_SEGMENT)

typedef __TLR_PACKED_PRE struct SIII_SL_COM_PROC_CMD_S_0_0128_EXEC_RES_DATA_Ttag
{
  TLR_UINT8                                         bSlaveIdx;
  TLR_UINT32                                        aulS_0_0022_List[SIII_SL_COM_PROC_CMD_S_0_0128_EXEC_RES_DATA_MAX_IDNS_PER_SEGMENT];
} __TLR_PACKED_POST SIII_SL_COM_PROC_CMD_S_0_0128_EXEC_RES_DATA_T;

typedef struct SIII_SL_COM_PROC_CMD_S_0_0128_EXEC_RES_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_PROC_CMD_S_0_0128_EXEC_RES_DATA_T     tData;
} SIII_SL_COM_PROC_CMD_S_0_0128_EXEC_RES_T;


/******************************************************************************
 * Packet: SIII_SL_COM_CMD_PROC_CMD_S_0_1024_EXEC_IND/SIII_SL_COM_CMD_PROC_CMD_S_0_1024_EXEC_RES
 */
/* indication packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_PROC_CMD_S_0_1024_EXEC_IND_DATA_Ttag
{
  TLR_UINT8                                         bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_PROC_CMD_S_0_1024_EXEC_IND_DATA_T;

typedef struct SIII_SL_COM_PROC_CMD_S_0_1024_EXEC_IND_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_PROC_CMD_S_0_1024_EXEC_IND_DATA_T     tData;
} SIII_SL_COM_PROC_CMD_S_0_1024_EXEC_IND_T;


/* response packet */

typedef __TLR_PACKED_PRE struct SIII_SL_COM_PROC_CMD_S_0_1024_EXEC_RES_DATA_Ttag
{
  TLR_UINT8                                         bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_PROC_CMD_S_0_1024_EXEC_RES_DATA_T;

typedef struct SIII_SL_COM_PROC_CMD_S_0_1024_EXEC_RES_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_PROC_CMD_S_0_1024_EXEC_RES_DATA_T     tData;
} SIII_SL_COM_PROC_CMD_S_0_1024_EXEC_RES_T;


/******************************************************************************
 * Packet: SIII_SL_COM_CMD_SET_IDENT_LED_IND/SIII_SL_COM_CMD_SET_IDENT_LED_RES
 */
/* indication packet */
typedef struct SIII_SL_COM_SET_IDENT_LED_IND_DATA_Ttag
{
  TLR_UINT32                                        ulIdentLedActiveBitMask;
} SIII_SL_COM_SET_IDENT_LED_IND_DATA_T;

typedef struct SIII_SL_COM_SET_IDENT_LED_IND_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_SET_IDENT_LED_IND_DATA_T              tData;
} SIII_SL_COM_SET_IDENT_LED_IND_T;


/* response packet */
typedef struct SIII_SL_COM_SET_IDENT_LED_RES_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} SIII_SL_COM_SET_IDENT_LED_RES_T;

/******************************************************************************
 * Packet: SIII_SL_COM_CMD_UPDATE_DEVICE_STATUS_REQ/SIII_SL_COM_CMD_UPDATE_DEVICE_STATUS_CNF
 */
/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_UPDATE_DEVICE_STATUS_REQ_DATA_Ttag
{
  TLR_UINT8                                         bSlaveIdx;
  TLR_UINT16                                        usDeviceStatus;           /* CB_bit will be ored from all independent setters, all other will be explicitly set and cleared */
  TLR_UINT16                                        usDeviceStatusModifyMask; /* only bits which have been set here will be changed */
} __TLR_PACKED_POST SIII_SL_COM_UPDATE_DEVICE_STATUS_REQ_DATA_T;

typedef struct SIII_SL_COM_UPDATE_DEVICE_STATUS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_UPDATE_DEVICE_STATUS_REQ_DATA_T       tData;
} SIII_SL_COM_UPDATE_DEVICE_STATUS_REQ_T;

/* bits for controlling application allowed device status bits */
#define MSK_SIII_SL_COM_DEVICE_STATUS_PARAMETERIZATION_LEVELS     0x0010
#define MSK_SIII_SL_COM_DEVICE_STATUS_PROC_COMMAND_CHANGE_BIT     0x0020
#define MSK_SIII_SL_COM_DEVICE_STATUS_C2D_WARNING_BIT             0x0040
#define MSK_SIII_SL_COM_DEVICE_STATUS_C1D_ERROR_BIT               0x0080
#define MSK_SIII_SL_COM_DEVICE_STATUS_ERROR_OCCURED               0x0200
#define MSK_SIII_SL_COM_DEVICE_STATUS_COMMUNICATION_WARNING       0x8000

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_UPDATE_DEVICE_STATUS_CNF_DATA_Ttag
{
  TLR_UINT8                                         bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_UPDATE_DEVICE_STATUS_CNF_DATA_T;

typedef struct SIII_SL_COM_UPDATE_DEVICE_STATUS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_UPDATE_DEVICE_STATUS_CNF_DATA_T       tData;
} SIII_SL_COM_UPDATE_DEVICE_STATUS_CNF_T;

/******************************************************************************
 * Packet: SIII_SL_COM_CMD_SET_SERCOS_ADDRESSES_REQ/SIII_SL_COM_CMD_SET_SERCOS_ADDRESSES_CNF
 */
/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_SET_SERCOS_ADDRESSES_REQ_DATA_Ttag
{
  TLR_UINT32                                        ulChangeFlags;
  TLR_UINT32                                        ulAddressNotChangeableBits;  /* bits enabled by ulChangeFlags */
  TLR_UINT16                                        ausSercosAddresses[8]; /* addresses enabled by ulChangeFlags */

} __TLR_PACKED_POST SIII_SL_COM_SET_SERCOS_ADDRESSES_REQ_DATA_T;
typedef struct SIII_SL_COM_SET_SERCOS_ADDRESSES_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_SET_SERCOS_ADDRESSES_REQ_DATA_T       tData;
} SIII_SL_COM_SET_SERCOS_ADDRESSES_REQ_T;

/* confirmation packet */
typedef struct SIII_SL_COM_SET_SERCOS_ADDRESSES_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} SIII_SL_COM_SET_SERCOS_ADDRESSES_CNF_T;


/******************************************************************************
 * Packet: SIII_SL_COM_CMD_SERCOS_ADDRESS_CHANGED_IND/SIII_SL_COM_CMD_SERCOS_ADDRESS_CHANGED_RES
 */
/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_SERCOS_ADDRESS_CHANGED_IND_DATA_Ttag
{
  TLR_UINT8                                         bSlaveIdx;
  TLR_UINT16                                        usSercosAddress;
} __TLR_PACKED_POST SIII_SL_COM_SERCOS_ADDRESS_CHANGED_IND_DATA_T;

typedef struct SIII_SL_COM_SERCOS_ADDRESS_CHANGED_IND_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_SERCOS_ADDRESS_CHANGED_IND_DATA_T     tData;
} SIII_SL_COM_SERCOS_ADDRESS_CHANGED_IND_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_SERCOS_ADDRESS_CHANGED_RES_DATA_Ttag
{
  TLR_UINT8                                         bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_SERCOS_ADDRESS_CHANGED_RES_DATA_T;

typedef struct SIII_SL_COM_SERCOS_ADDRESS_CHANGED_RES_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_SERCOS_ADDRESS_CHANGED_RES_DATA_T     tData;
} SIII_SL_COM_SERCOS_ADDRESS_CHANGED_RES_T;


/******************************************************************************
 * Packet:  SIII_SL_COM_CMD_INIT_COMPLETED_IND/SIII_SL_COM_CMD_INIT_COMPLETED_RES
 */
/* indication packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_INIT_COMPLETED_IND_DATA_Ttag
{
  TLR_UINT32                                        ulInitCompletedFlags;
} __TLR_PACKED_POST SIII_SL_COM_INIT_COMPLETED_IND_DATA_T;

typedef struct SIII_SL_COM_INIT_COMPLETED_IND_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_INIT_COMPLETED_IND_DATA_T             tData;
} SIII_SL_COM_INIT_COMPLETED_IND_T;

/* response packet */
typedef struct SIII_SL_COM_INIT_COMPLETED_RES_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} SIII_SL_COM_INIT_COMPLETED_RES_T;

#define SIII_SL_COM_INIT_COMPLETED_SVC_TASK_STARTED           0x00000001
#define SIII_SL_COM_INIT_COMPLETED_AP_TASK_STARTED            0x00000002
#define SIII_SL_COM_INIT_COMPLETED_NRT_TASK_STARTED           0x00000004

/* application reserved bits 16-31 */
#define SIII_SL_COM_INIT_COMPLETED_APP_0_STARTED              0x00010000
#define SIII_SL_COM_INIT_COMPLETED_APP_1_STARTED              0x00020000
#define SIII_SL_COM_INIT_COMPLETED_APP_2_STARTED              0x00040000
#define SIII_SL_COM_INIT_COMPLETED_APP_3_STARTED              0x00080000

/******************************************************************************
 * Packet:  SIII_SL_COM_CMD_WRITE_DIAGNOSTIC_REQ/SIII_SL_COM_CMD_WRITE_DIAGNOSTIC_CNF
 */
/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_WRITE_DIAGNOSTIC_REQ_DATA_Ttag
{
  TLR_UINT8                                         bSlaveIdx;
  TLR_UINT8                                         bClass;                   /* only used if Diagnostic number is fully manufacturer specific */
  TLR_UINT8                                         abDiagnosticMessage[100]; /* NUL-terminated string unless all characters are used */
  TLR_UINT32                                        ulDiagnosticNumber;
  /* more data depending on S-0-1303.0.1 */
} __TLR_PACKED_POST SIII_SL_COM_WRITE_DIAGNOSTIC_REQ_DATA_T;

#define SIII_SL_COM_DIAGNOSTIC_CLASS_INFO                               0x09
#define SIII_SL_COM_DIAGNOSTIC_CLASS_OPERATIONAL_STATE                  0x0A
#define SIII_SL_COM_DIAGNOSTIC_CLASS_RESERVED                           0x0B
#define SIII_SL_COM_DIAGNOSTIC_CLASS_PROCEDURE_COMMAND_SPECIFIC_STATE   0x0C
#define SIII_SL_COM_DIAGNOSTIC_CLASS_RESERVED2                          0x0D
#define SIII_CL_COM_DIAGNOSTIC_CLASS_WARNINGS                           0x0E
#define SIII_SL_COM_DIAGNOSTIC_CLASS_FAULTS                             0x0F

typedef struct SIII_SL_COM_WRITE_DIAGNOSTIC_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_WRITE_DIAGNOSTIC_REQ_DATA_T           tData;
} SIII_SL_COM_WRITE_DIAGNOSTIC_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_WRITE_DIAGNOSTIC_CNF_DATA_Ttag
{
  TLR_UINT8                                         bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_WRITE_DIAGNOSTIC_CNF_DATA_T;

typedef struct SIII_SL_COM_WRITE_DIAGNOSTIC_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_COM_WRITE_DIAGNOSTIC_CNF_DATA_T           tData;
} SIII_SL_COM_WRITE_DIAGNOSTIC_CNF_T;


/******************************************************************************
 * Packet:  SIII_SL_COM_CMD_REMOVE_DIAGNOSTIC_REQ/SIII_SL_COM_CMD_REMOVE_DIAGNOSTIC_CNF
 *
 * Packet is used to remove diagnosis (warnings and/or errors) previously reported by this application via SIII_SL_COM_CMD_WRITE_DIAGNOSTIC_REQ packet.
 * It is not possible to remove stack internal diagnosis or diagnosis reported by an other application through this packet.
 * We recommend to remove each disappearing error with the flag SIII_SL_COM_DIAGNOSTIC_FUNCTION_ERASE_SPECIFIC_DIAGNOSIS
 * and its diagnostic number equal given at SIII_SL_COM_CMD_WRITE_DIAGNOSTIC_REQ packet.
 * But it is also possible to remove all diagnosis (warnings and/or errors) reported by this application.
 */
/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_REMOVE_DIAGNOSTIC_REQ_DATA_Ttag
{
  TLR_UINT8                                         bSlaveIdx;         /* the slave a diagnosis shall be removed */
  TLR_UINT32                                        ulFunctionFlags;    /* see defines, action that shall be done */
  TLR_UINT32                                        ulDiagnosticNumber;/* error code that shall be removed */
  /* more data depending on S-0-1303.0.1 */
} __TLR_PACKED_POST SIII_SL_COM_REMOVE_DIAGNOSTIC_REQ_DATA_T;

#define SIII_SL_COM_DIAGNOSTIC_FUNCTION_REMOVE_SPECIFIC_DIAGNOSIS                    0x00000000 /* Erase one diagnosis message (the oldest if more are available) where the ulDiagnosticNumber matches (reported by this application previously) */
#define SIII_SL_COM_DIAGNOSTIC_FUNCTION_REMOVE_ALL_SPECIFIC_DIAGNOSIS                0x00000010 /* Erase all diagnosis messages where the ulDiagnostic Number matches (reported by this application previously) */
#define SIII_SL_COM_DIAGNOSTIC_FUNCTION_REMOVE_ALL_ERRORS                            0x00000001 /* Erase all errors (reported by this application previously) */
#define SIII_SL_COM_DIAGNOSTIC_FUNCTION_REMOVE_ALL_WARNINGS                          0x00000002 /* Erase all warnings (reported by this application previously) */
#define SIII_SL_COM_DIAGNOSTIC_FUNCTION_REMOVE_ALL_PROCEDURE_COMMAND_SPECIFIC_STATES 0x00000004 /* Erase all procedure command specific states (reported by this application previously) */
#define SIII_SL_COM_DIAGNOSTIC_FUNCTION_REMOVE_ALL_OPERATIONAL_STATES                0x00000008 /* Erase all operational states (reported by this application previously) */
#define MSK_SIII_SL_COM_DIAGNOSTIC_FUNCTION_REMOVE_ALL                               0x0000000F

typedef struct SIII_SL_COM_REMOVE_DIAGNOSTIC_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                tHead;
  SIII_SL_COM_REMOVE_DIAGNOSTIC_REQ_DATA_T           tData;
} SIII_SL_COM_REMOVE_DIAGNOSTIC_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_REMOVE_DIAGNOSTIC_CNF_DATA_Ttag
{
  TLR_UINT8                                         bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_REMOVE_DIAGNOSTIC_CNF_DATA_T;

typedef struct SIII_SL_COM_REMOVE_DIAGNOSTIC_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                tHead;
  SIII_SL_COM_REMOVE_DIAGNOSTIC_CNF_DATA_T           tData;
} SIII_SL_COM_REMOVE_DIAGNOSTIC_CNF_T;

/******************************************************************************
 * Packet:  SIII_SL_COM_CMD_REGISTER_S_0_99_INDICATIONS_REQ/SIII_SL_COM_CMD_REGISTER_S_0_99_INDICATIONS_CNF
 */
/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_REGISTER_S_0_99_INDICATIONS_REQ_DATA_Ttag
{
  TLR_UINT8                                             bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_REGISTER_S_0_99_INDICATIONS_REQ_DATA_T;

typedef struct SIII_SL_COM_REGISTER_S_0_99_INDICATIONS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_REGISTER_S_0_99_INDICATIONS_REQ_DATA_T    tData;
} SIII_SL_COM_REGISTER_S_0_99_INDICATIONS_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_REGISTER_S_0_99_INDICATIONS_CNF_DATA_Ttag
{
  TLR_UINT8                                             bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_REGISTER_S_0_99_INDICATIONS_CNF_DATA_T;

typedef struct SIII_SL_COM_REGISTER_S_0_99_INDICATIONS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_REGISTER_S_0_99_INDICATIONS_CNF_DATA_T    tData;
} SIII_SL_COM_REGISTER_S_0_99_INDICATIONS_CNF_T;

/******************************************************************************
 * Packet:  SIII_SL_COM_CMD_REGISTER_TRACE_BUFFER_INDICATIONS_REQ/SIII_SL_COM_CMD_REGISTER_TRACE_BUFFER_INDICATIONS_CNF
 */

#define SIII_SL_COM_DIAGNOSTIC_TRACE_BUFFER_INSERT_NOT_OWN_TASK         0x00 /* Do not report Trace Buffer Update indications if the registering task and reporting task are identical */
#define SIII_SL_COM_DIAGNOSTIC_TRACE_BUFFER_INSERT_ALWAYS               0x01 /* Report Trace Buffer Update Indications also if reporting and registering task are identical (report all diagnosis messages) */
#define SIII_SL_COM_DIAGNOSTIC_TRACE_BUFFER_DISABLED                    0x80 /* Also report indications if the Buffer was disabled through S-0-1302.0.2 or not matches the threshold */
#define MSK_SIII_SL_COM_DIAGNOSTIC_TRACE_BUFFER                         0x81

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_REGISTER_TRACE_BUFFER_INDICATIONS_REQ_DATA_Ttag
{
  TLR_UINT8                                             bSlaveIdx;
  TLR_UINT8                                             bAllInserts; /* if set to 1 also own registered indications are send back */
} __TLR_PACKED_POST SIII_SL_COM_REGISTER_TRACE_BUFFER_INDICATIONS_REQ_DATA_T;

typedef struct SIII_SL_COM_REGISTER_TRACE_BUFFER_INDICATIONS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_REGISTER_TRACE_BUFFER_INDICATIONS_REQ_DATA_T    tData;
} SIII_SL_COM_REGISTER_TRACE_BUFFER_INDICATIONS_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_REGISTER_TRACE_BUFFER_INDICATIONS_CNF_DATA_Ttag
{
  TLR_UINT8                                             bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_REGISTER_TRACE_BUFFER_INDICATIONS_CNF_DATA_T;

typedef struct SIII_SL_COM_REGISTER_TRACE_BUFFER_INDICATIONS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_REGISTER_TRACE_BUFFER_INDICATIONS_CNF_DATA_T    tData;
} SIII_SL_COM_REGISTER_TRACE_BUFFER_INDICATIONS_CNF_T;


/******************************************************************************
 * Packet:  SIII_SL_COM_CMD_UNREGISTER_TRACE_BUFFER_INDICATIONS_REQ/SIII_SL_COM_CMD_UNREGISTER_TRACE_BUFFER_INDICATIONS_CNF
 */
/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_UNREGISTER_TRACE_BUFFER_INDICATIONS_REQ_DATA_Ttag
{
  TLR_UINT8                                             bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_UNREGISTER_TRACE_BUFFER_INDICATIONS_REQ_DATA_T;

typedef struct SIII_SL_COM_UNREGISTER_TRACE_BUFFER_INDICATIONS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_UNREGISTER_TRACE_BUFFER_INDICATIONS_REQ_DATA_T    tData;
} SIII_SL_COM_UNREGISTER_TRACE_BUFFER_INDICATIONS_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_UNREGISTER_TRACE_BUFFER_INDICATIONS_CNF_DATA_Ttag
{
  TLR_UINT8                                             bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_UNREGISTER_TRACE_BUFFER_INDICATIONS_CNF_DATA_T;

typedef struct SIII_SL_COM_UNREGISTER_TRACE_BUFFER_INDICATIONS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_UNREGISTER_TRACE_BUFFER_INDICATIONS_CNF_DATA_T    tData;
} SIII_SL_COM_UNREGISTER_TRACE_BUFFER_INDICATIONS_CNF_T;

/******************************************************************************
 * Packet:  SIII_SL_COM_CMD_TRACE_BUFFER_UPDATE_IND/SIII_SL_COM_CMD_TRACE_BUFFER_UPDATE_RES
 */
/* request packet */

/* A new element was inserted into the Buffer. Also the user application has to add an element into it's own buffer */
#define SIII_SL_COM_PROC_CMD_TRACE_BUFFER_UPDATE_INSERTED_INTO_BUFFER    0
/* The buffer was reset, also the user application has to reset it's buffer */
#define SIII_SL_COM_PROC_CMD_TRACE_BUFFER_UPDATE_RESET_BUFFER            1

typedef __TLR_PACKED_PRE struct SIII_SL_COM_TRACE_BUFFER_UPDATE_IND_DATA_Ttag
{
  TLR_UINT8                                             bSlaveIdx;
  TLR_UINT8                                             bFlag;
  TLR_UINT32                                            ulDiagnosticNumber; /* just valid if bFlag is set to zero; the currently inserted diagnostic number, should not be needed by application task, just for information purpose */
  TLR_UINT16                                            usBufferMode;  /* 0 = Ringbuffer, 1 = Listbuffer */
} __TLR_PACKED_POST SIII_SL_COM_TRACE_BUFFER_UPDATE_IND_DATA_T;

typedef struct SIII_SL_COM_TRACE_BUFFER_UPDATE_IND_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_TRACE_BUFFER_UPDATE_IND_DATA_T            tData;
} SIII_SL_COM_TRACE_BUFFER_UPDATE_IND_T;

/* confirmation packet */
typedef struct SIII_SL_TRACE_BUFFER_UPDATE_RES_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
} SIII_SL_COM_TRACE_BUFFER_UPDATE_RES_T;

/******************************************************************************
 * Packet:  SIII_SL_COM_CMD_REGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_REQ/SIII_SL_COM_CMD_REGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_CNF
 */
/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_REGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_REQ_DATA_Ttag
{
  TLR_UINT8                                             bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_REGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_REQ_DATA_T;

typedef struct SIII_SL_COM_REGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_REGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_REQ_DATA_T    tData;
} SIII_SL_COM_REGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_REGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_CNF_DATA_Ttag
{
  TLR_UINT8                                             bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_REGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_CNF_DATA_T;

typedef struct SIII_SL_COM_REGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_REGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_CNF_DATA_T    tData;
} SIII_SL_COM_REGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_CNF_T;


/******************************************************************************
 * Packet:  SIII_SL_COM_CMD_UNREGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_REQ/SIII_SL_COM_CMD_UNREGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_CNF
 */
/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_UNREGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_REQ_DATA_Ttag
{
  TLR_UINT8                                             bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_UNREGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_REQ_DATA_T;

typedef struct SIII_SL_COM_UNREGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_UNREGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_REQ_DATA_T    tData;
} SIII_SL_COM_UNREGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_UNREGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_CNF_DATA_Ttag
{
  TLR_UINT8                                             bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_UNREGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_CNF_DATA_T;

typedef struct SIII_SL_COM_UNREGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_UNREGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_CNF_DATA_T    tData;
} SIII_SL_COM_UNREGISTER_TEST_IDN_DIAGNOSTIC_EVENT_INDICATIONS_CNF_T;



/******************************************************************************
 * Packet:  SIII_SL_COM_CMD_TEST_IDN_DIAGNOSTIC_UPDATE_IND/SIII_SL_COM_CMD_TEST_IDN_DIAGNOSTIC_UPDATE_RES
 */
/* request packet */

typedef __TLR_PACKED_PRE struct SIII_SL_COM_TEST_IDN_DIAGNOSTIC_UPDATE_IND_DATA_Ttag
{
  TLR_UINT8                                             bSlaveIdx;
  TLR_BOOLEAN8                                          bBufferMode; /* 0 = Ringbuffer, 1 = Listbuffer */
  TLR_UINT32                                            ulDiagnosticNumber;
} __TLR_PACKED_POST SIII_SL_COM_TEST_IDN_DIAGNOSTIC_UPDATE_IND_DATA_T;

typedef struct SIII_SL_COM_TEST_IDN_DIAGNOSTIC_UPDATE_IND_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_TEST_IDN_DIAGNOSTIC_UPDATE_IND_DATA_T     tData;
} SIII_SL_COM_TEST_IDN_DIAGNOSTIC_UPDATE_IND_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct TEST_IDN_DIAGNOSTIC_UPDATE_RES_DATA_Ttag
{
  TLR_UINT8                                             bSlaveIdx;
} __TLR_PACKED_POST TEST_IDN_DIAGNOSTIC_UPDATE_RES_DATA_T;

/* confirmation packet */
typedef struct SIII_SL_TEST_IDN_DIAGNOSTIC_UPDATE_RES_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  TEST_IDN_DIAGNOSTIC_UPDATE_RES_DATA_T                 tData;
} SIII_SL_COM_TEST_IDN_DIAGNOSTIC_UPDATE_RES_T;

/******************************************************************************
 * Packet:  SIII_SL_COM_CMD_UNREGISTER_S_0_99_INDICATIONS_REQ/SIII_SL_COM_CMD_UNREGISTER_S_0_99_INDICATIONS_CNF
 */
/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_UNREGISTER_S_0_99_INDICATIONS_REQ_DATA_Ttag
{
  TLR_UINT8                                             bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_UNREGISTER_S_0_99_INDICATIONS_REQ_DATA_T;

typedef struct SIII_SL_COM_UNREGISTER_S_0_99_INDICATIONS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_UNREGISTER_S_0_99_INDICATIONS_REQ_DATA_T  tData;
} SIII_SL_COM_UNREGISTER_S_0_99_INDICATIONS_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_UNREGISTER_S_0_99_INDICATIONS_CNF_DATA_Ttag
{
  TLR_UINT8                                             bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_UNREGISTER_S_0_99_INDICATIONS_CNF_DATA_T;

typedef struct SIII_SL_COM_UNREGISTER_S_0_99_INDICATIONS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_UNREGISTER_S_0_99_INDICATIONS_CNF_DATA_T  tData;
} SIII_SL_COM_UNREGISTER_S_0_99_INDICATIONS_CNF_T;

/******************************************************************************
 * Packet:  SIII_SL_COM_CMD_CHANGE_CONNECTION_DATA_OFFSETS_REQ/SIII_SL_COM_CMD_CHANGE_CONNECTION_DATA_OFFSETS_CNF
 */
/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_CHANGE_CONNECTION_DATA_OFFSETS_CONFIG_DATA_REQ_Ttag
{
  uint8_t                                               bSlaveIdx;
  uint8_t                                               bConnectionIdx;
  uint16_t                                              usConnCtrlOffset;
  uint16_t                                              usRtDataOffset;
  uint16_t                                              usRtDataMaxLength;

}SIII_SL_COM_CHANGE_CONNECTION_DATA_OFFSETS_CONFIG_DATA_REQ_T;

typedef __TLR_PACKED_PRE struct SIII_SL_COM_CHANGE_CONNECTION_DATA_OFFSETS_DATA_REQ_Ttag
{
  uint8_t bFlags;
  uint8_t bNumberOfConnections;
  SIII_SL_COM_CHANGE_CONNECTION_DATA_OFFSETS_CONFIG_DATA_REQ_T atConfiguration[64];
} __TLR_PACKED_POST SIII_SL_COM_CHANGE_CONNECTION_DATA_OFFSETS_DATA_REQ_T;

typedef struct SIII_SL_COM_CHANGE_CONNECTION_DATA_OFFSETS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_CHANGE_CONNECTION_DATA_OFFSETS_DATA_REQ_T  tData;
} SIII_SL_COM_CHANGE_CONNECTION_DATA_OFFSETS_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_CHANGE_CONNECTION_DATA_OFFSETS_DATA_CNF_Ttag
{
  TLR_UINT8                                             bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_CHANGE_CONNECTION_DATA_OFFSETS_DATA_CNF_T;

typedef struct SIII_SL_COM_CHANGE_CONNECTION_DATA_OFFSETS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_CHANGE_CONNECTION_DATA_OFFSETS_DATA_CNF_T  tData;
} SIII_SL_COM_CHANGE_CONNECTION_DATA_OFFSETS_CNF_T;

#define SIII_SL_COM_CHANGE_CONNECTION_DATA_REMOVE_CONNECTIONS_PREVIOUSLY           0x00000001

/******************************************************************************
 * Packet:  SIII_SL_COM_CMD_PROC_CMD_S_0_0099_EXEC_IND/SIII_SL_COM_CMD_PROC_CMD_S_0_0099_EXEC_RES
 */
/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_PROC_CMD_S_0_0099_EXEC_IND_DATA_Ttag
{
  TLR_UINT8                                             bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_PROC_CMD_S_0_0099_EXEC_IND_DATA_T;

typedef struct SIII_SL_COM_PROC_CMD_S_0_0099_EXEC_IND_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_PROC_CMD_S_0_0099_EXEC_IND_DATA_T         tData;
} SIII_SL_COM_PROC_CMD_S_0_0099_EXEC_IND_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_PROC_CMD_S_0_0099_EXEC_RES_DATA_Ttag
{
  TLR_UINT8                                             bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_COM_PROC_CMD_S_0_0099_EXEC_RES_DATA_T;

typedef struct SIII_SL_COM_PROC_CMD_S_0_0099_EXEC_RES_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_PROC_CMD_S_0_0099_EXEC_RES_DATA_T         tData;
} SIII_SL_COM_PROC_CMD_S_0_0099_EXEC_RES_T;


/******************************************************************************
 * Packet: SIII_SL_COM_CMD_CHANGE_DIVCLK_SETTINGS_IN_CP3_CP4_REQ/SIII_SL_COM_CMD_CHANGE_DIVCLK_SETTINGS_IN_CP3_CP4_CNF
 */
/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_CHANGE_DIVCLK_SETTINGS_IN_CP3_CP4_REQ_DATA_Ttag
{
  TLR_UINT32                                            ulDivModeControl;
  TLR_UINT32                                            ulConClkLength;
  TLR_UINT32                                            ulTDivClk;
  TLR_UINT32                                            ulNDivClk;
} __TLR_PACKED_POST SIII_SL_COM_CHANGE_DIVCLK_SETTINGS_IN_CP3_CP4_DATA_T;

typedef struct SIII_SL_COM_CHANGE_DIVCLK_SETTINGS_IN_CP3_CP4_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_CHANGE_DIVCLK_SETTINGS_IN_CP3_CP4_DATA_T  tData;
} SIII_SL_COM_CHANGE_DIVCLK_SETTINGS_IN_CP3_CP4_REQ_T;


typedef struct SIII_SL_COM_CHANGE_DIVCLK_SETTINGS_IN_CP3_CP4_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
} SIII_SL_COM_CHANGE_DIVCLK_SETTINGS_IN_CP3_CP4S_CNF_T;




/******************************************************************************
 * Packet:  SIII_SL_COM_CMD_IDENT_REQ/SIII_SL_COM_CMD_IDENT_RES
 */
/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_COM_IDENT_REQ_DATA_Ttag
{
  TLR_UINT32                                            ulIdentLedActiveBitMask;
  TLR_UINT32                                            ulActiveTimeInMs;
} __TLR_PACKED_POST SIII_SL_COM_IDENT_REQ_DATA_T;

typedef struct SIII_SL_COM_IDENT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_SL_COM_IDENT_REQ_DATA_T                          tData;
} SIII_SL_COM_IDENT_REQ_T;

/* confirmation packet */
typedef struct SIII_SL_COM_IDENT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
} SIII_SL_COM_IDENT_CNF_T;


/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__SIII_SL_COM_PACKET)
#endif

/*************************************************************************************/
#endif /* #ifndef __SIII_SL_COM_PUBLIC_H */
